// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.

#include "LayerPropWin.h"

Fl_Menu_Item LayerPropWin::menu_[] = {
 {"Help", 0,  0, 0, 0, 0, 0, 14, 56},
 {0}
};



LayerPropWin::LayerPropWin(int which_layer) {

    char my_string[256];
    mWhichLayer = which_layer;

    mIsDispActivate = false;

  Fl_Window* w;
  { Fl_Window* o = UIMainWindow = new Fl_Window(241, 198);
    w = o;
    o->box(FL_UP_BOX);
    o->user_data((void*)(this));
    w->hotspot(o);


    //sprintf(my_string,"Layer #%d",mWhichLayer);
    //printf("%s \n", my_string);
   
    { Fl_Box* o = UILayerName = new Fl_Box(0, 0, 230, 20, "");
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      o->label("Layer Properties");
    }


    { Fl_Group* o = new Fl_Group(5, 50, 195, 25, "Dispersion:");
      o->labelsize(15);
      o->labelcolor(80);
      o->align(FL_ALIGN_TOP_LEFT);
      new Fl_Box(5, 50, 55, 25, "Material:");
      { Fl_Button* o = UISelectButton = new Fl_Button(145, 50, 50, 25, "Select");
        o->box(FL_ROUND_UP_BOX);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->labelsize(13);
	o->callback((Fl_Callback*)UISelectButtonCallback,this);
      }
      { Fl_Box* o = UIMaterialBox = new Fl_Box(60, 50, 80, 25, "N.N");
        o->box(FL_DOWN_BOX);
        o->color(26);
      }
      o->end();
      { Fl_Check_Button* o = UICheckButton = new Fl_Check_Button(200, 55, 20, 20, "Off");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)UICheckButtonCallback,this);

    }

    }
    { Fl_Group* o = new Fl_Group(5, 110, 215, 25, "Birefringence:");
      o->labelcolor(80);
      o->align(FL_ALIGN_TOP_LEFT);
      new Fl_Box(5, 110, 40, 25, "Index:");
      { Fl_Input* o = new Fl_Input(80, 110, 50, 25, "nTE");
        o->type(1);
      }
      { Fl_Input* o = new Fl_Input(170, 110, 45, 25, "nTM");
        o->type(1);
      }
      o->end();
    }
    { Fl_Menu_Bar* o = new Fl_Menu_Bar(160, 0, 70, 20);
      o->box(FL_FLAT_BOX);
      o->menu(menu_);
    }
    { Fl_Button* o = UIDismissButton = new Fl_Button(165, 160, 55, 25, "OK");
    o->callback((Fl_Callback*)UIDismissButtonCallback,this);
    }
   
    o->end();
  }
}

void LayerPropWin::Show() {
 UIMainWindow->show();
}

void LayerPropWin::Hide() {
   UIMainWindow->hide();

}

void LayerPropWin::UIDismissButtonCallback(Fl_Button* o , LayerPropWin* v)
{
    v->Hide();
    return;

}

void LayerPropWin::UISelectButtonCallback(Fl_Button* o, LayerPropWin* v)
{
     
    v->mpFileName = fl_file_chooser("Select Disp File ", "*.disp", NULL,1 );
    //v->UICheckButton->value(1);
    //v->UICheckButton->label("On");
    //v->mIsDispActivate = true;  
  if(v->mpFileName!=NULL)
    {
	v->mpNameOfMaterial = fl_filename_name(v->mpFileName);
        v->UIMaterialBox->label(v->mpNameOfMaterial);
    }
    
  // printf("Layer %d, file: %s\n",v->mWhichLayer, v->mpFileName);
}

void LayerPropWin::UICheckButtonCallback(Fl_Button* o, LayerPropWin* v)
{
    if( v->mIsDispActivate )
    {
     v->mIsDispActivate = false;
	
	o->label("Off");

	//printf("Activate %d\n",(int)v->mIsDispActivate);
          
      v->UIMaterialBox->deactivate();
	
    }
 else if (!v->mIsDispActivate )
 {
     v->mIsDispActivate = true;
       o->label("On");
//printf("Activate %d\n",(int)v->mIsDispActivate);
       v->UIMaterialBox->activate();
    
 }

  

}




















