
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.

#ifndef _datafile
#define _datafile
#include <iostream>
#include <fstream>
#include <vector>
#include <complex>
#include "layer.h"



class DATAFILE
{ 

 private:
   const char *filename;
    
   ofstream outfile;

   ifstream infile; 

   vector <double> x;
   
   vector <double> y;

   int s;
  
   int j;
  
   int count_mini;
   
   vector <double> mini_values; 
   
   double max;
    
 public:

  DATAFILE();

  void read_file(char *name,Layer *layer);
  
  void read_file(const char *name);
 
  void write_file(char *name, vector <double> xv , vector <double> yv );
  
  void write_file(char *name, 
                  vector <double> xv,
                  vector <double> yv,
                  Layer *layer );
  
  void write_file(const char *name, vector <double> xv , double *y);

  void write_file(const char *name, double *x , double *y, int size);
  
  void analyse_file();

  void print_x();

  void print_y();
 
  void print();

  int no_lines();
 
  int no_mini(){return count_mini;}

  void print_mini();
  
  vector <double> &xvalue(){return x;} 
 
  vector <double> &yvalue(){return y;}
    
  double scale(){return max;}
};

#endif





