
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#ifndef _YEH
#define _YEH

#include "layer.h"
#include "matrix.h"
#include "constants.h"
#include <FL/math.h>

class YEH{

private:

double R;

YehMatrix D,P,G,D_0,D_N,E;

 
public:

double yehfunc(Layer *layer, double angle, complex <double> n0 , double lambda ,int N , int pola );


double yehfunc(Layer *layer,
	       double angle,
	       complex <double> n0,
	       double lambda,
	       int N,
	       int _bool_layer[],
	       int pola,
	       int _result,
	       int _period );

double calculate_R(){return R;} 

complex <double> GenerateComplexNumber(double a,double b)
  {
    complex <double> z(a,b);
    return z;
  }
};
#endif







