// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.

#include "graph.h"


Graph::Graph(int x, int y, int w, int h):Fl_Group(x,y,w,h){

   

  const double PercentageAxisWidth =0.1 ;
   
   mAutoScale = true;
   mCounter =0;
   mMultiSets = true;

 {
     mpClearDataButton = new Fl_Button(x,y,50,25,"Clear");
     mpClearDataButton->labelsize(12);
     mpClearDataButton->label("Clear");
     mpClearDataButton->tooltip("Clear all plots");
     mpClearDataButton->callback((Fl_Callback*)ClearDataButtonCallback,this);
     
 

 }
 {
     mpMultiSetsButton = new Fl_Light_Button(x+65,y,50,25,"Multi");
     mpMultiSetsButton->value(1);
     mpMultiSetsButton->labelsize(12);
     mpMultiSetsButton->label("Multi");
     mpMultiSetsButton->tooltip("Allow 10 Sets parallel");
     mpMultiSetsButton->callback((Fl_Callback*)MultiSetsButtonCallback,this);
     
 

 }
 { 
     mpAutoScaleButton = new Fl_Light_Button(x+120,y,50,25,"Autoscale");
     mpAutoScaleButton->value(1);
     mpAutoScaleButton->labelsize(12);
     mpAutoScaleButton->label("Auto");
    mpAutoScaleButton->tooltip("Auto Scale y-axis ");
     mpAutoScaleButton->callback((Fl_Callback*)AutoScaleButtonCallback,this);
 }

 {
   mpYAxisMinMaxInputGroup = new Fl_Group(x+175,y,190,25); 

   
   mpYAxisMinInput = new Fl_Float_Input(x+200,y,30,25,"Min.");
   mpYAxisMinInput->value("0.0");
   mpYAxisMinInput->tooltip("Minimum value for y-axis");
   mpYAxisMaxInput = new Fl_Float_Input(x+270,y,30,25,"Max.");

   mpYAxisMaxInput->value("1.0");
   mpYAxisMaxInput->tooltip("Maximum value for y-axis");
   mpYAxisMinMaxInputGroup->deactivate(); 
   end();
    
 }

 
 
    //less space for canvas and axis :-(

    y=y+45;
    h=h-45;
     
 


  
    {
      pCanvas = new Ca_Canvas(x+PercentageAxisWidth*w, y ,w-PercentageAxisWidth*w ,h-PercentageAxisWidth*h, " ");
    
      pCanvas->box(FL_BORDER_BOX);
    }
   
    { 
        pXaxis = new Ca_X_Axis(x+PercentageAxisWidth*w , y+(h-PercentageAxisWidth*h),w-PercentageAxisWidth*w, h*PercentageAxisWidth  , " ");

	 pXaxis->scale(CA_LIN);
	 pXaxis->Min(0.0);
         pXaxis->Max(1);
	 pXaxis->major_step(0.1);

      //pXaxis->box(FL_DOWN_BOX);
        pXaxis->labelsize(12);
	pXaxis->align(FL_ALIGN_BOTTOM);
       
	// pXaxis->border(0);
    } 
   
    { 
        pYaxis = new Ca_Y_Axis(x,y , w*PercentageAxisWidth, h-(h*PercentageAxisWidth), " ");

	pYaxis->scale(CA_LIN);
        pYaxis->Min(0.0);
	pYaxis->Max(1);
	pYaxis->major_step(0.1);

     // pYaxis->box(FL_DOWN_BOX);

        pYaxis->labelsize(12);
        pYaxis->align(FL_ALIGN_TOP_LEFT);
       
	pYaxis->border(0);
      
        pYaxis->label_format("%.2f");

    }

   end();    

}



void Graph::AxisLabel(const char *s, int whichAxis)
{ 
    switch(whichAxis)
    {
	case XAXIS:
	{ pXaxis->label(s);
	
	pXaxis->redraw();
	break;
	}

    case YAXIS:
    {
	pYaxis->label(s);
        
        pYaxis->redraw();
	break;

    }
    
 default:
     break;
    }


}


const char* Graph::AxisLabel(int whichAxis)
{ 
    switch(whichAxis)
    {
	case XAXIS:
	{ return  pXaxis->label();
	  break;
	}

    case YAXIS:
    {
	return pYaxis->label();
	break;
    }
    
 default:
	 return NULL;
     break;
    }
}



 void Graph::AxisScale(int min, int max,int whichAxis)
{
 
  switch(whichAxis)
    {
	case XAXIS:
	{
	 pXaxis->Min(min);
	 pXaxis->Max(max);
 	break;
	}

    case YAXIS:
    {
	pYaxis->Min(min);
	pYaxis->Max(max);
	break;
    }
    
 default:
     break;
    }
}


void Graph::AxisLabelFormat(const char* FormatString,int whichAxis)
{
  switch(whichAxis)
    {
	case XAXIS:
	{
	 pXaxis->label_format(FormatString);
	break;
	}

    case YAXIS:
    {
	pYaxis->label_format(FormatString);
	
	break;
    }
    
 default:
     break;
    }
}


void Graph::PlotData(vector <double> x, vector <double> y, int SetNumber, int LineStyle )
{
    
    int i;
    
    Fl_Color CurrentColor;

    pCanvas->current();

    pYaxis->Min(y[0]);
    pYaxis->Max(0);

    pXaxis->Min(x[0]);
    pXaxis->Max(x[x.size()-1]);

    pXaxis->current();
    pYaxis->current();


    if(!SetNumber) ClearData();

    if(mMultiSets == false) ClearData();


    mActualSetNumber = mCounter;
    
    CurrentColor = (Fl_Color)(mCounter);

    if(mCounter == MAX_DATA_SETS){

	pLinePoint[mActualSetNumber] = NULL;
	fl_message("Too much data sets");
	ClearData();
        mCounter= 0;
  	
	return ;
    }

   
    for (i=0;i<=x.size()-1;i++)
    {
 	 
     	if(LineStyle == CLINE)
	   { 
       	 pLinePoint[mActualSetNumber] = new Ca_LinePoint(pLinePoint[mActualSetNumber],
                                                                                 x[i],
                                                                                 y[i],
                                                                                    1,
                                                                         CurrentColor,
                                                                            CA_SIMPLE,
                                                                   DEFAULT_POINT_SIZE,                                                                                                       FL_BLACK,
                                                                                     0);
	   }	 
        else if(LineStyle == CPOINTS)
	   {
                             pPoint = new Ca_Point(x[i],
                                                    y[i],
                                                    CurrentColor, 
                                                    CA_SQUARE,
                                                    2,
                                                    FL_BLACK,
                                                    0);
	   }
       	 
    if(IsAutoScale()) 
    {
      pYaxis->rescale(CA_WHEN_MAX|CA_WHEN_MIN,y[i]);
    }
    else
    { pYaxis->Min(atof(mpYAxisMinInput->value() ));
      pYaxis->Max( atof(mpYAxisMaxInput->value() )) ;
    }
  }
    pLinePoint[mActualSetNumber] = NULL;
    pPoint = NULL;
  if(mMultiSets)
    {
    if(SetNumber)     mCounter++; // just for testing 
    }
  else
  {  
     mCounter= 0;
  }
 
return;

}



void Graph::RedrawPlot(void)
{

    
    
   pCanvas->redraw();
   pXaxis->redraw();
   pYaxis->redraw();
   this->redraw();
  return;
     
}

void Graph::ClearData(void)
{  
       
    pCanvas->clear();
    return;
}

 




void Graph::ClearDataButtonCallback(Fl_Button* o, Graph* v)
{

    v->mCounter = 0;
    v->ClearData();

    return;


}


void Graph::AutoScaleButtonCallback(Fl_Button* o, Graph* v)
{
    if (v->IsAutoScale())
    {
	v->mAutoScale = false;
	
	o->label("Fix");

       v->mpYAxisMinMaxInputGroup->activate();


    }
    else if (!v->IsAutoScale())
    {
	v->mAutoScale = true;
        o->label("Auto");
	v->mpYAxisMinMaxInputGroup->deactivate();
     }
    v->redraw();

    return;
}


void Graph::MultiSetsButtonCallback(Fl_Button* o, Graph* v)
{
    if(!o->value())
    {
	//o->value(0);

    o->label("Single");
    o->tooltip("just one dataset");
    v->mMultiSets = false;

    }
else
 {
     o->label("Multi");
     // o->value(1);
     o->tooltip(" max. 10 datasets ");
     v->mMultiSets = true;

 }
    v->redraw();


}

















