// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
#ifndef _GRAPH
#define _GRAPH
#include "Cartesian.h"
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.h>
#include <FL/Fl_Light_Button.h>
#include <FL/Fl_Float_Input.h>
#include <FL/fl_message.H>

#include <vector>

using namespace std;

enum {XAXIS, YAXIS};

enum {CLINE,CPOINTS};

const int  MAX_DATA_SETS =10;


class Graph : public Fl_Group
{

 public:

  Graph(int x, int y, int w, int h);
  
  void AxisLabel(const char* s, int whichAxis);

  const  char* AxisLabel(int whichAxis ); 

  void AxisScale(int min, int max,int whichAxis);

  void AxisLabelFormat( const char* FormatString,
                                int whichAxis);    // like c-format string "\3.4f"

  
  
  void PlotData(vector <double> x,
                vector <double> y,
                int SetNumber,
                int LineStyle);
  
  void RedrawPlot(void);

  void ClearData(void);


  private:

  int mCounter,
      mActualSetNumber;

  
  bool mAutoScale,
       mMultiSets;

  Fl_Button* mpClearDataButton;
  Fl_Button* mpAutoScaleButton;
  Fl_Button* mpMultiSetsButton;
  Fl_Group* mpYAxisMinMaxInputGroup;    
  Fl_Float_Input* mpYAxisMinInput;
  Fl_Float_Input* mpYAxisMaxInput;
   
  Ca_Canvas *pCanvas;
  Ca_X_Axis *pXaxis;
  Ca_Y_Axis *pYaxis;
  
  Ca_LinePoint *pLinePoint[MAX_DATA_SETS];  

  Ca_Point *pPoint;


  bool IsAutoScale(void){ return mAutoScale;}

  static void ClearDataButtonCallback(Fl_Button* o , Graph* v);

  static void AutoScaleButtonCallback(Fl_Button* o, Graph* v);

  static void MultiSetsButtonCallback(Fl_Button* o, Graph* v);

};
#endif











