//  rsim 1.0
//
// Copyright 1999 - 2001 by Markus Leitz
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.

#include "graphUI.h"

#include <Fl/fl_message.H>

void GRAPHUI::show_graph(double _x, double _y)
{
   xaxis->current();
   yaxis->current();
   pp[0] =  new Ca_LinePoint(pp[0],_x,_y,FL_YELLOW,FL_BLACK,CA_DOWN_TRIANGLE|CA_BORDER); 
 
 //   if(UIautoon->value())
//       {
//     yaxis->rescale(CA_WHEN_MAX,_y);  
//       }
 
}   
   

void GRAPHUI::show_graph(vector <double> _x, vector <double> _y)
{  
   int i;
   ymin = _y[0];
   ymax = 0.0;

    
     xaxis->current();
     yaxis->current();
     xaxis->min(_x[0]);
     xaxis->max(_x[_x.size()-1]);
       
       
     for (i=0;i<=_x.size()-1;i++)
       {
         if(_y[i]< ymin) ymin=_y[i];
	 if(_y[i] > ymax) ymax =_y[i];
 
       	 pp[0] = new Ca_LinePoint(pp[0],_x[i],_y[i]);
	 //new Ca_Point(_x[i],_y[i],FL_BLACK,FL_BLACK,CA_ROUND,2);
	 
         yaxis->min(ymin);
         yaxis->max(ymax);
	
	//   if(UIautoon->value())
//  	   {
//  	 yaxis->rescale(CA_WHEN_MAX|CA_WHEN_MIN,_y[i]);  
//  	 xaxis->rescale(CA_WHEN_MAX|CA_WHEN_MIN,_x[i]);     
//  	   }
	
       }
    
     pp[0] = NULL;
}

void GRAPHUI::show_graph(vector <double> _x, vector <double> _y, int number,int type)
{  
   int i;
   ymin = _y[0];
   ymax = 0.0;
 
     xaxis->current();
     yaxis->current();
     // xaxis->min(_x[0]);
     // xaxis->max(_x[_x.size()-1]);
    
     
  for (i=0;i<=_x.size()-1;i++)
     {
      if(_y[i]< ymin) ymin=_y[i];
      if(_y[i] > ymax) ymax =_y[i];
	if(type == 0)
	   { 
       	 pp[number] = new Ca_LinePoint(pp[number],_x[i],_y[i],FL_BLACK);
	   }	 
        else if(type == 1)
	   {
            p = new Ca_Point(_x[i],_y[i]);
	   }
       if(UIautoscale->value())
        { 
         yaxis->min(ymin);
         yaxis->max(ymax);
         }
          else
         {
          yaxis->min(0.0);
          yaxis->max(1.05);
         }

	 
     }
    
     pp[number] = NULL;
     p = NULL; 
}


void GRAPHUI::change_xaxis_label(const char *s)
{
  // fl_message(s);
  xaxis->current(); 
  xaxis->label(s);
 
 
}

void GRAPHUI::change_xaxis_scaling(int min, int max)
{
  
  xaxis->min(min); 
  xaxis->max(max);
 
 
}

void GRAPHUI::change_yaxis_label(const char *s)
{
  yaxis->label(s);

}

void GRAPHUI::myredraw(void){
  win->redraw();
}

 
void GRAPHUI::clear_graph(void){
 
 
 //  canvas->current();
 //    xaxis->current();
 //    yaxis->current();

  // show_graph(_x,_y,0);
     
  
  canvas->clear();
  //  canvas->redraw();
}


void GRAPHUI::quit()
{ 
  win->hide();
}
















