
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


#include "layer.h"


//class definitions for class Layer 
int Layer::NumberOfLayers = -1;


Layer::Layer()
{

    mDispersion=  DISPOFF;
    NumberOfLayers++;
    mNumberOfThisLayer = NumberOfLayers;
    //cout << NumberOfLayers << mNumberOfThisLayer <<  endl;
    
    mpPropWin = new LayerPropWin(mNumberOfThisLayer);

}





bool Layer::SelectMaterial(char* filename)
{
    char my_string[256];

    mDispersionParameter.clear();

    mLayerMaterialFile.open(filename);

  if(!mLayerMaterialFile) 
  {
      
	 return false;
  }
  
  while(mLayerMaterialFile.getline(my_string,256))
  {
      if(my_string[0] !=  35)
      {   
	 mDispersionParameter.push_back(atof(my_string));
	 // cout << my_string << endl;

      }
  }


   mLayerMaterialFile.close();
   return true;


}

bool Layer::CalculateDispersIndex(double _lambda)
{
    
    int number_coefficients_real=0,
	number_coefficients_imag=0;

    int file_header_offset = 4;

    int i=0;

    double re=0.0;
    double im = 0.0;
  
  number_coefficients_real =(int) mDispersionParameter[2];
  number_coefficients_imag =(int) mDispersionParameter[3];
 


 if(_lambda >= mDispersionParameter[0] && _lambda <=  mDispersionParameter[1])
 {
 

//calculate real part of refractive index 
     for(i=0;i<=number_coefficients_real;i++)
     {
	 re+=  mDispersionParameter[file_header_offset+i] * pow(_lambda,i);
              
}

//calcuate imaginary part of refractive  index 
     for(i=0;i<=number_coefficients_imag;i++)
     {
	 im+=  mDispersionParameter[file_header_offset+number_coefficients_real+i] * pow(_lambda,i);
	
     }


     RefractiveIndex(re,im);
    
    
     return  true;

 }
else
 {
// out of lambda range
		
     return false;
 }
 

}





void Layer::PropagationVector(double angle, complex <double> n0, double lambda)
{ 
  mAngle = angle;
  mLambda = lambda ;
  mRefractiveIndexMedium0 = n0;

  mProp = ISO;
  
  mRefractiveIndexTM = mRefractiveIndex;

  switch(mProp)
    {
    case (ISO):
     
      if( mpPropWin->mIsDispActivate )
		{
			SelectMaterial(mpPropWin->mpFileName);
			{
	    
				if ( ! CalculateDispersIndex(lambda) ) 
				{
				
				}
			}
		

            
			//cout <<  "in layer.cpp" <<  lambda/1e-9 << mRefractiveIndex << endl; 
	}

      mPropagationVector = (2.0*M_PI/lambda) * sqrt ( (mRefractiveIndex*mRefractiveIndex) - (n0*sin(angle)*n0*sin(angle)) );
      break;

    case (ANISO):
     

      mPropagationVector = mRefractiveIndex / mRefractiveIndexTM * (2.0*M_PI/lambda) * sqrt((mRefractiveIndexTM*mRefractiveIndexTM)- (n0*sin(angle)*n0*sin(angle))) ; 
      break;

    default:
      break;
    }

  
}


 
 
void Layer::OpticalPhase(void)
{  

  
    
  

  if(    abs( 2.0*mThickness*mRefractiveIndex  )   >  pow(650e-9 , 2)/10e-9   )
  {      
      mCoherenceLength = 1; // light is incoherent
    
      mOpticalPhase = GenerateComplexNumber(0.0, mThickness.real() * mPropagationVector.imag() );  
     
      
       
  } 

else

    {
    
      mCoherenceLength = 0; // light is coherent
    
      mOpticalPhase = mThickness*mPropagationVector;
  
    } 
}






void Layer::PrintParameterToScreen()
{
  cout << "information about current layer: " << endl << "thickness:  " << mThickness <<endl << "index:  " << mRefractiveIndex << endl ;
}  




void Layer::SaveParameterToFile(char  *filename)
{ 
  ofstream file;
  file.open(filename);

   file << "Index: " << mRefractiveIndex  << "thickness :" << mThickness  << endl; 
}












