
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.

#ifndef _YehMatrix
#define _YehMatrix
#include <complex>
#include <iostream>
#include <cmath>
#include <FL/math.h>


using namespace std;

class YehMatrix
{

public:


 // constructors     
YehMatrix();

YehMatrix(char *s);
  

// operator overloading


YehMatrix& operator=(YehMatrix m1);

YehMatrix  operator*(YehMatrix m1);

YehMatrix& operator*=(YehMatrix m1);


// functions
     

      
void Print();  
    
void SetManual();

complex <double> Determinant();  
       
int Size(); 


YehMatrix InversMatrix();

void IdentityMatrix(); 
  
void LoadTransferMatrix(double lambda, complex <double> n, complex <double> k,int pola);

 
void LoadPhaseMatrix(complex <double> p, int coherence_lenght);


complex <double> PickElement (int i,int j);





protected:

	complex <double> mComplexMatrix[2][2];


private:


 complex <double> GenerateComplexNumber(double a,double b){ complex <double> z(a,b); return z;}


};


#endif


































