// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.

#include <iostream>
#include <fstream>
#include <cstdlib> 
#include <cstdio>
#include <vector>
#include <FL/math.h>
#include <FL/fl_file_chooser.H>
#include <FL/fl_message.H>
#include "rsimUI.h"
#include "chisquare.h"
#include "background.h"
 

 

int RsimUserInterface::show(void)
{ 
  if(! MainWindow->shown() )
    { 
     MainWindow->show();
     return 1;
    }
 else 
   {
     return 0;
   }
}



void RsimUserInterface::init(void)
{
  
  lambda = 632.8e-9; // HeNe Laser wavelength
  angle =0.0;
  N=6;

  stack_period = 1;

  layer = new Layer[N+2];

  bool_layer[6] = (1,0,0,0,0,0); 
 

  step=0.1;
  delta->value(step);
  min = (int) 0.0; // start at 0 degrees
 
  ui_min->value(min);

  max = (int)  90.0 ; // end at 90 degrees
  
  ui_max->value(max);

  

  pola = 0;
  mode = RvTHETA;
  result = REFLECTIVITY;

  n0_ui->value(1.5151);
  k0->value(0.0);

  d1->value(2.0e-6);
  n1->value(1.302);
  k1->value(0.001);
  bool_layer[1] = 1; 


  d2->value(0.0e-6);
  n2->value(1.0);
  k2->value(0.0);
  bool_layer[2] = 0; 

  d3->value(0.0e-6);
  n3->value(1.0);
  k3->value(0.0);
  bool_layer[3] = 0; 


  d4->value(0.0e-6);
  n4->value(1.0);
  k4->value(0.0);
  bool_layer[4] = 0; 


  d5->value(0.0e-6);
  n5->value(1.0);
  k5->value(0.0);
  bool_layer[5] = 0; 

  d6->value(0.0e-6);
  n6->value(1.0);
  k6->value(0.0);
  bool_layer[6] = 0; 

  n7->value(1.00029);
  k7->value(0.0);
 
 

 
//  graph = new GRAPHUI();
 // graph->show();
  
  


}


void RsimUserInterface::read_parameter(void)
{

  layer[0].Thickness(0.0);

  layer[0].RefractiveIndex(n0_ui->value(), k0->value()  );
  n0 = layer[0].RefractiveIndex(); // set this as n0

  layer[1].Thickness( d1->value() );
  layer[1].RefractiveIndex( n1->value(),  k1->value()  );
  if( n1->value() > 0)  N=1;

  layer[2].Thickness(  d2->value()  );
  layer[2].RefractiveIndex( n2->value(), k2->value()  );
  if( n2->value() > 0)  N=2;

  layer[3].Thickness( d3->value() );
  layer[3].RefractiveIndex( n3->value(), k3->value()  );
  if( n3->value() > 0)  N=3;
 
  layer[4].Thickness(  d4->value()  );
  layer[4].RefractiveIndex( n4->value(), k4->value() );
  if( n4->value() > 0)  N=4;

  layer[5].Thickness(  d5->value() );
  layer[5].RefractiveIndex( n5->value(),  k5->value());
  if( n5->value() > 0)  N=5;

  layer[6].Thickness(  d6->value() );
  layer[6].RefractiveIndex( n6->value(),  k6->value() );
  if( n6->value() > 0)  N=6;

  layer[N+1].Thickness(0.0);

  layer[N+1].RefractiveIndex( n7->value(), k7->value() );


  step =  delta->value();

  min = (int)(ui_min -> value() / step); // start at x degrees

  max = (int)( ui_max->value()  / step  - step) ; // end at x+ degrees

  //cout << angle_max  << "   " << angle_min "finish read_para" << endl;

 



}

void RsimUserInterface::calc(void)

{ 
  double lambda_old,angle_old;
    
  read_parameter();
 
  double *A = new double[3];
  switch(mode)
   {
   case (RvTHETA):
     angle_old = angle;
     if(min < max)
       {
      for(t=min;t<=max;t++)  // start loop over angle 
	{

	  angle = (double) t*M_PI/180 * step; // angle in radian
     


	  R.push_back(1.0*yeh.yehfunc(layer,
                                  angle,
                                  n0,
                                  lambda,
                                  N,
                                  bool_layer,
                                  pola,
				  result,
				  stack_period) ); //calculate the reflectivity with "yehfunc" and store it in the vector "R" 
 
      
 
  
	  theta.push_back(angle*180/M_PI); // write down the angle 
 
 
	}
      
          
      nGraph->AxisLabel("angle[degree]", XAXIS);
      //  nGraph->AxisLabel("reflectivity",YAXIS);
 
      //   nGraph->ClearData();

      nGraph->PlotData(theta,R,1,CLINE);       
      
 
      save_angle = theta;
      save_ref = R;

      R.clear();
      theta.clear();
      angle = angle_old;  
       }
     else
       { 
           fl_alert("Sorry, min and max are interchanged");
       }
     break;

   case (RvLAMBDA):
     lambda_old = lambda;
     
     
   if( min < max )
       {  
	 for(t=min;t<=max;t++)  // start loop over wavelength 
	   {
 
	  lambda = (double) (t * step * 1e-9); // wavelength
     
	  // cout << lamp( (lambda/1e-7)) << endl;
	 
	  if(background == BACKGROUND_ON)
	    {
	      R.push_back( lamp(lambda/1e-7) * yeh.yehfunc(layer,
                                                           angle,
                                                           n0,
                                                           lambda,
                                                           N,
                                                           bool_layer,
                                                           pola,
							   result,
							   stack_period)); //calculate the reflectivity with "yehfunc" and store it in the vector "R"   
	    }
	  else
	    {
	      R.push_back(yeh.yehfunc(layer,
                                      angle,
                                      n0,
                                      lambda,
                                      N,
                                      bool_layer,
                                      pola,
				      result,
				      stack_period)); //calculate the reflectivity with "yehfunc" and store it in the vector "R"  
            }	  

	  theta.push_back(lambda/1e-9); // write down the angle 
	    
 
	}
     
        
//      nGraph->ClearData();
       
      nGraph->PlotData(theta,R,1,CLINE); 
      
      save_angle = theta;
      save_ref = R;

      R.clear();
      theta.clear();
      lambda = lambda_old;
       }
   else
     { 
       fl_alert("Sorry, min and max are interchanged");
     }
    break;

   default:
     break;
   }

 
}



void RsimUserInterface::save_data(void)
{ 

  filename = fl_file_chooser("Save File?", "*.dat","");
  if(filename)
    { 
   
      file.write_file(filename,save_angle,save_ref,layer);
      fl_message("Plot saved in ASCII FORMAT");
    } 

  else 
    { 

      fl_alert("No file selected");

    }


}

void RsimUserInterface::load_data(void)
{ 
  filename = fl_file_chooser("Open File?", "*.dat","");
  if(filename)
    { 
   
      file.read_file(filename,layer);

      R.clear();
      theta.clear();

      theta = file.xvalue(); 
      R = file.yvalue();

      //   graph->clear_graph();
      // graph->show_graph(theta,R,0,0);  

      // save_angle = theta;
      // save_ref = R;

      R.clear();
      theta.clear();
    } 
 
  else 
    { 

      fl_alert("No file selected");

 
    }
}

void RsimUserInterface::import_data(void)
{
 
  //  fl_message("import data");
filename = fl_file_chooser("Open File?", "*.dat","");
  if(filename)
    { 
   
      file.read_file(filename);

      xdata.clear();
      ydata.clear();

      xdata = file.xvalue(); 
      ydata = file.yvalue();

      // graph->clear_graph();
      // graph->show_graph(xdata,ydata,1,1);  
         
     
      
    } 
 
  else 
    { 

      fl_alert("No file selected");

 
    }


}

void RsimUserInterface::mode_wavelength_callback(void)
{
mode = RvLAMBDA;

 status_box->labelfont(12);
 status_box->label("q =");
 status_box_label->label("deg.");
 status_box->value(angle); 
 status_group->redraw();

 menu_options_wavelength->deactivate();
 menu_options_angle->activate();

ui_min->value(500);
ui_max->value(1100);
delta->value(0.5);
background = fl_ask("Do you want to use a background spectrum");

nGraph->AxisLabel("lambda[nm]", XAXIS);
//nGraph->AxisLabel("reflectivity",YAXIS);	   
calc();
 MainWindow->redraw(); // to update (show) the new labels 

}
 

void RsimUserInterface::mode_angle_callback(void)
{
mode = RvTHETA;
status_box->labelfont(12);
 status_box->label("l ="); 
 status_box_label->label("nm");
 status_box->value(lambda/1e-9); 
 status_group->redraw(); 
 
 menu_options_angle->deactivate();
 menu_options_wavelength->activate();
 
ui_min->value(0);
ui_max->value(90);
delta->value(0.1);
nGraph->AxisLabel("angle[degree]", XAXIS);
//nGraph->AxisLabel("reflectivity",YAXIS);	   
calc();

 MainWindow->redraw(); // to update all labels 

}














