// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
#ifndef LayerPropWin_h
#define LayerPropWin_h
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Check_Button.H>
#include <FL/fl_file_chooser.H>
#include <cstdio>
#include "layer.h"

class LayerPropWin {
public:

 friend class Layer;
 
LayerPropWin(int which_layer);

 void Show();

 void Hide();

private:
 

  char* mpFileName;
  
  const char* mpNameOfMaterial;

  int mWhichLayer;  

  bool mIsDispActivate;
 

//-----------------------------------

  static Fl_Menu_Item menu_[];
  
  Fl_Window *UIMainWindow;
  Fl_Box *UILayerName;
  Fl_Button *UISelectButton;
  Fl_Box* UIMaterialBox;
  Fl_Check_Button *UICheckButton;
  Fl_Button* UIDismissButton;


  static void UIDismissButtonCallback(Fl_Button* o , LayerPropWin* v);

  static void UISelectButtonCallback(Fl_Button* o , LayerPropWin* v);
 
  static void UICheckButtonCallback(Fl_Button* o, LayerPropWin* v);
};
#endif


































