// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
#include "dispersion.h"

complex <double> set(double a,double b){ complex <double> z(a,b); return z;}

complex <double> n_disp(int type, double lambda)
{
  double *A,*B;
  
  double re=0.0 , im =0.0;

  complex <double> temp;
 
  char  *typestring;
  
  int i,N;
  
    

  N = 5;
        
  A= new double[N];
  B = new double[N];  

 switch(type)
    { 
      case (SILVER):
	typestring = "SILVER";
	A[0] = 1.198 ;
	A[1] =-5.351e+06 ;
        A[2] = 9.652e+12 ;
        A[3] =-7.538e+18 ;
        A[4] = 2.244e+24 ;
      
	B[0] =-10.48 ;
	B[1] = 5.876e+07 ;
	B[2] =-9.782e+13 ;
	B[3] = 8.024e+19 ;   
        B[4] =-2.391e+25 ;   

       break;

      case (TEFLON):
        typestring = "TEFLON";
	A[0] = 1.335 ;
	A[1] = -6.088e+04;
	A[2] = 3.664e+10 ;
	A[3] = 0.0;
        A[4] = 0.0;
        
        B[0] = 1e-6;
	B[1] = 0.0;
	B[2] = 0.0;
	B[3] = 0.0;
	B[4] = 0.0;
 
        break;

    case (BK7):
    typestring = "BK7";
        A[0] =  1.613   ;
	A[1] = -3.508e+05  ;
	A[2] = 4.619e+11  ;
	A[3] = -2.784e+17 ;
        A[4] = 6.235e+22 ;
        
        B[0] = 1e-6;
	B[1] = 0.0;
	B[2] = 0.0;
	B[3] = 0.0;
	B[4] = 0.0;
   break;
    case (AIR):
        typestring = "AIR";
	A[0] = 1.00029 ;
	A[1] = 0.0;
	A[2] = 0.0 ;
	A[3] = 0.0;
        A[4] = 0.0;
        
        B[0] = 1e-7;
	B[1] = 0.0;
	B[2] = 0.0;
	B[3] = 0.0;
	B[4] = 0.0;
    break;
  case (WATER):
    typestring = "WATER";    
	A[0] = 1.438  ;
	A[1] = -4.728e+05   ;
	A[2] =  8.138e+11  ;
        A[3] =  -6.542e+17 ;
        A[4] = 2.004e+23 ;

        B[0] = 1e-6;
	B[1] = 0.0;
	B[2] = 0.0;
	B[3] = 0.0;
	B[4] = 0.0;
  break;
      default:
        
        break;
     }

   for (i=0;i<=N-1;i++)
       { 
              
	 //    cout << "No " << " " << i << " " <<   A[i] << "   " << B[i] << endl;

	   re += A[i] * pow(lambda,i);
           im += B[i] * pow(lambda,i);
       }

   //   cout  << typestring  << " " << lambda <<  "  real  "  << re << "  imag " << im << endl; 
     
     //cin >> input;
     
     
     temp = set(re,im);
     delete A;
     delete B;
     return  temp;


}

  
bool n_disp_file(char* filename,double lambda,complex <double>* ref_index)
{
  
  int number_coefficients_real,
      number_coefficients_imag;

  int file_header_offset = 4;
   
 

  vector <double> parameter;
  
  double re=0.0 , im =0.0;

  complex <double> temp;
 
   char string[256];
  
  int i,count;
  
 
  
  ifstream myfile;

  
  myfile.open(filename);

  if(!myfile) 
  {
      fl_message("I/O Error");
  }
  count =0;
  while(myfile.getline(string,256))
  {
      if(string[0] !=  35)
      {   
	 
	  
	  parameter.push_back(atof(string));
	  //cout << parameter[count] << endl;
	  count++;
      }
  }
 
  number_coefficients_real =(int) parameter[2];
  number_coefficients_imag =(int) parameter[3];
 


 if(lambda >= parameter[0] && lambda <=  parameter[1])
 {
 

//caluclate real part of refractive index 
     for(i=0;i<=number_coefficients_real;i++)
     {
	 re+=  parameter[file_header_offset+i] * pow(lambda,i);
     }

//calcuate imaginary part of refractive  index 
     for(i=0;i<=number_coefficients_imag;i++)
     {
	 im+=  parameter[file_header_offset+number_coefficients_real+i] * pow(lambda,i);
     }

     *ref_index = set(re,im);
     
    
     return  true;

 }
else
 {
// out of lambda range
     return false;
 }

}











