 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.

//#include "complex.h"
#include "func.h"


double YEH::yehfunc(Layer *layer,
                    double angle,
                    complex <double> n0,
                    double lambda,
                    int N,
                    int pola)
{
  
    //YEHMATRIX E("unity");
  double R;
  int i;  
  E.IdentityMatrix();   // set this matrix to the identity matrix

  // angle = (double) t*M_PI/180 * dangle;     // calculate the angel  in rad
   
 

  for(i=1;i<=N;i++) // start loop over the layers 
   {
    
    
    layer[i].PropagationVector(angle,n0,lambda);
 
    

    layer[i].OpticalPhase();
    
         
    D.LoadTransferMatrix(lambda,
                         layer[i].RefractiveIndex(),
                         layer[i].PropagationVector(),
                         pola);
 
    P.LoadPhaseMatrix(layer[i].OpticalPhaseValue(),
                      layer[i].CoherenceLength() );
 
  
 // loadmatrix means to write in the elements                                         

   
    
    E*=D*P*D.InversMatrix();  // matrix multiplication over the layers
   
     
   }
     
  layer[0].PropagationVector(angle,n0,lambda);

  layer[N+1].PropagationVector(angle,n0,lambda);
  
  D_0.LoadTransferMatrix(lambda,
                         layer[0].RefractiveIndex(),
                         layer[0].PropagationVector(),
                         pola);

  D_N.LoadTransferMatrix(lambda,
                         layer[N+1].RefractiveIndex(),
                         layer[N+1].PropagationVector(),
                         pola);
 
  G = D_0.InversMatrix()*E*D_N; // multiplication refered to the bounding media (e.g prism, air) 
        
  

 return  R= pow(abs(G.PickElement(1,0)/G.PickElement(0,0)),2); 
 

} 
  
 
double YEH::yehfunc(Layer *layer,
		     double angle,
		     complex <double> n0,
		     double lambda,
		     int N,
		     int _bool_layer[],
		     int pola,
		     int _result,
		     int _period)

{
    complex <double> factor;

    //YEHMATRIX E("unity");
  double R,T,A;
  int i=0,
      j;  
  
  int actual_layer=0,
      actual_period=1;

 


  E.IdentityMatrix();   // set this matrix to the identity matrix

  // angle = (double) t*M_PI/180 * dangle;     // calculate the angel  in rad
   
  /* if(layer[0].Dispersion() == DISPON)
	{ 
	   n0 = n_disp(layer[0].LayerMaterial(),lambda);
	}
  */

 layer[0].PropagationVector(angle,n0,lambda);

 n0 = layer[0].RefractiveIndex();

// cout << n0   << " -- " << layer[0].RefractiveIndex() << endl;

 for(j=1;j<=(N*_period);j++) // start loop over the layers 
   {
     // cout << "LAYER " << i << " " << layer[i].disp() << endl; 
    
       if(j == actual_period*N+1)
       {
	   i=0;
	   actual_period++;
       }
       
       i++;


  if(_bool_layer[i])
    {
     
     
     
     layer[i].PropagationVector(angle,n0,lambda);
 
     layer[i].OpticalPhase();
    
          
     D.LoadTransferMatrix(lambda,
                          layer[i].RefractiveIndex(),
                          layer[i].PropagationVector(),
                          pola);
 

     P.LoadPhaseMatrix(layer[i].OpticalPhaseValue(),
                       layer[i].CoherenceLength());

 // loadmatrix means to write in the elements                                         

   
    
     E*=D*P*D.InversMatrix();  // matrix multiplication over the layers
   
    }
     
   }
     

 

  layer[N+1].PropagationVector(angle,n0,lambda);
  

  D_0.LoadTransferMatrix(lambda,
                         layer[0].RefractiveIndex(),
                         layer[0].PropagationVector(),
                         pola);

  D_N.LoadTransferMatrix(lambda,
                         layer[N+1].RefractiveIndex(),
                         layer[N+1].PropagationVector(),
                         pola);
 
 // multiplication refered to the bounding media (e.g prism, air) 

   G = D_0.InversMatrix()*E*D_N;

        
 R= pow(abs(G.PickElement(1,0)/G.PickElement(0,0)),2);

 factor =  layer[N+1].PropagationVector()/layer[0].PropagationVector();

 // cout << factor << endl;
 
//total reflection 
if(factor.real() == 0.0 && factor.imag() != 0.0) 
 {
   T=0.0;
 }
else 
 {
     T =  abs(factor) *  pow( abs ( 1.0 /  G.PickElement(0,0) )  ,2); 
 }

   switch(_result)
   {
       case(REFLECTIVITY):
	   
	   return  R; 
           break;
	   
       case(TRANSMISSION):
	    

	   return  T; 
	   break;

       case(ABSORPTION):


	        return  A= 1-R-T; 
	       break;
        		
	   default:
		   return R;
		   break;

   }

} 
  


























