
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


#ifndef _Layer
#define _Layer
#include <complex>
#include <vector>
#include <fstream>
#include <FL/math.h>
#include <iostream>
#include <cmath>
#include <cstdlib>
#include <FL/fl_message.H>
#include "constants.h"
#include "dispersion.h"
#include "LayerPropWin.h"

#ifdef WIN32
#include <windows.h>
#endif 

using namespace std;


class Layer
{ 
 
public:

  friend class LayerPropWin;

  Layer();

  LayerPropWin* mpPropWin; 
  
// set methods:
  
  void PropagationVector(double angle, complex <double> n0, double lambda);
  
  void OpticalPhase(void);
    
  void LayerMaterial(int m){mLayerMaterial = m;}

  void RefractiveIndex(double r,double i){ mRefractiveIndex  = GenerateComplexNumber(r,i);}

  void Thickness(complex <double> _d){ mThickness = _d;}

 void Thickness(double _d){ mThickness = GenerateComplexNumber(_d,0.0); }


void RefractiveIndex(complex <double> _n)
 {
  mRefractiveIndex = _n; 
 }


void RefractiveIndexReal( double _nreal)
 {
   mRefractiveIndex = GenerateComplexNumber(_nreal,mRefractiveIndex.imag());
 } 

  
void RefractiveIndexImag( double _nimag)
 {
  mRefractiveIndex = GenerateComplexNumber(mRefractiveIndex.real(),_nimag);
 }
  
  void Dispersion(int d){ mDispersion = d;}
 
  void SetValues(char *name,int type);
   
  void PrintParameterToScreen();
  
  void SaveParameterToFile(char *filename); 
  

  bool SelectMaterial(char* filename);

  bool CalculateDispersIndex(double _lambda);

//get methods: 
  
  complex <double> PropagationVector(){ return mPropagationVector;}

  complex <double> OpticalPhaseValue() {return mOpticalPhase;}

  complex <double> Thickness(){return mThickness;}
  
  complex <double> RefractiveIndex(){return mRefractiveIndex;} 
   
  

  double RefractiveIndexReal(){ return mRefractiveIndex.real();}

  double RefractiveIndexImag(){ return mRefractiveIndex.imag();}
  
  

  int LayerMaterial(){return mLayerMaterial; }
  
  int Dispersion(){return mDispersion;}
    
  int CoherenceLength(){return mCoherenceLength;}  
 

 private:
  
 static int NumberOfLayers;

 int mNumberOfThisLayer;

 complex <double> mRefractiveIndex, 
                  mThickness,
                  mPropagationVector,
                  mOpticalPhase; 

 
 
 complex <double> mRefractiveIndexTM,
                  mRefractiveIndexMedium0;


 //double dd,dn,dkappa; 

 double mAngle,
        mLambda;

 vector <double> mDispersionParameter; 

 char *mpName,
       *mpIso;
   
 int mTemp,
     mProp, 
     mLayerMaterial,
     mCoherenceLength;

 int mDispersion;

 ifstream  mLayerMaterialFile;

 char* mpLayerMaterialFileName;
  



 complex <double> GenerateComplexNumber(double a,double b)
  {
    complex <double> z(a,b);
    return z;
  }


    
  

};



#endif








