
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.



#include "matrix.h"

using namespace std;
 


YehMatrix::YehMatrix ()
{
  int i,j; 
   
  for (i=0;i<=1;i++)
    {
for(j=0;j<=1;j++)
  {  
     mComplexMatrix[i][j]=0.0;
  }
    }
}

YehMatrix::YehMatrix(char *s)
{ 
int i,j;
   
  for (i=0;i<=1;i++)
    {
for(j=0;j<=1;j++)
  {  
     mComplexMatrix[i][j]=0.0;
  }
    }
 
  mComplexMatrix[0][0] = (1,1);
  mComplexMatrix[1][1] = (1,1);
} 

   
YehMatrix& YehMatrix::operator=(YehMatrix m1)
{ 
   int i,j;
 
   for(i=0;i<=1;i++)
   {
     for(j=0;j<=1;j++)
     { 
     mComplexMatrix[i][j]= m1.mComplexMatrix[i][j];
     }
   } 
 
 return *this;

}
 
YehMatrix YehMatrix::operator* (YehMatrix m1)
{ 
  int k,l,m;
 
  YehMatrix result;  
  YehMatrix &res=result;        

  complex <double> TempMatrix[2][2];
 
for (k=0;k<=1;k++) 
 
 {  
   for (l=0;l<=1;l++)
   
   {  
      for (m=0;m<=1;m++)
       { 
       TempMatrix[k][l]+=mComplexMatrix[k][m]*m1.mComplexMatrix[m][l];
       } 
   
    result.mComplexMatrix[k][l] = TempMatrix[k][l];
  }  
 }
 
 return result;

}

YehMatrix& YehMatrix::operator*=(YehMatrix m1)
{
    int k,l,m;
 
   complex <double> t[2][2]; 
         

for (k=0;k<=1;k++) 
  
 { 
   for (l=0;l<=1;l++)
   
   { 
      for (m=0;m<=1;m++)
       { 
         t[k][l] = t[k][l]+mComplexMatrix[k][m]*m1.mComplexMatrix[m][l];
       } 
   } 
 }
for(k=0;k<=1;k++)
    { for(l=0;l<=1;l++)
      { mComplexMatrix[k][l] = t[k][l];}}
 
return *this;
 
}


complex <double> YehMatrix::Determinant()
{ 
 
  return mComplexMatrix[0][0]*mComplexMatrix[1][1]-mComplexMatrix[1][0]*mComplexMatrix[0][1];

}


 
void YehMatrix::Print() 
{ 
   int i,j;

  for(i=0;i<=1;i++)
    {
     for(j=0;j<=1;j++)
     { 
       cout << i << "," <<  j << "  " << mComplexMatrix[i][j] << endl ;
     } 
    } 
  cout << endl;
}
 
void YehMatrix::SetManual()
{ 
   
   int i,j;
   
   complex <double> z;
  
for(i=0;i<=1;++i)
    {
     for(j=0;j<=1;++j)
      { 
     
	cout << "Column " << i << "," << "Row " <<  j << "?" ; 
	 
         cin >> z; 
         
	  mComplexMatrix[i][j]=z;
           
            
     }
    }
return;
 } 

int YehMatrix::Size()
{ 
  return sizeof(this);
} 






YehMatrix YehMatrix::InversMatrix()
{ 
  complex <double> a;
  YehMatrix m1;
  YehMatrix& m2=m1;
  
  a = 1.0/Determinant();
 
  
  m1.mComplexMatrix[0][0] =  a*mComplexMatrix[1][1]; 
  m1.mComplexMatrix[0][1] = -a*mComplexMatrix[0][1];
  m1.mComplexMatrix[1][0] = -a*mComplexMatrix[1][0];
  m1.mComplexMatrix[1][1] =  a*mComplexMatrix[0][0];
 
  return m1;

}


void YehMatrix::IdentityMatrix()
{ 
 int i,j;
   
  for (i=0;i<=1;i++)
    {
for(j=0;j<=1;j++)
  {  
     mComplexMatrix[i][j]=0.0;
  }
    }
  
  mComplexMatrix[0][0] = (1,1);
  mComplexMatrix[1][1] = (1,1);
} 

  

  


void YehMatrix::LoadTransferMatrix(double lambda,
                                   complex <double> n,
                                   complex <double> k,
                                   int pola)
{  
 

 // cout << "in Loadmatrix" << endl;
 //cout << n  << " " << k << " "  << lambda  << endl;
  if( pola == 0 )  
   {
      mComplexMatrix[0][0] = 1.0; 
      mComplexMatrix[0][1] = 1.0;
      mComplexMatrix[1][0] = (k*lambda)/(2*M_PI); 
      mComplexMatrix[1][1] = (-1.0*k*lambda)/(2*M_PI); 
    }

  else if (pola == 1)
    {
	//cout << "TM CAse" << endl;
      mComplexMatrix[0][0] = (k/n)*(lambda/(2*M_PI)); 
      mComplexMatrix[0][1] = (k/n)*(lambda/(2*M_PI)); 
      mComplexMatrix[1][0] = n;
      mComplexMatrix[1][1] = -1.0*n;
  
      //  cout << M[0][0] << " "  << M[0][1] << " " <<    M[1][0] <<  "  " << M[1][1] << endl;  
  } 
  else 
    { 
      cout << "Wrong Polarisation" <<  endl;
    exit(0);
    }

}
void YehMatrix::LoadPhaseMatrix(complex <double> p, int coherence_length)
    { 
        
      complex <double> Ie(0.0,1.0);       
      complex <double> mI(0.0,-1.0);     
      complex <double> pe(-1.0,1.0); 
      complex <double> me(-1.0,-1.0);                
            
      
      if( coherence_length == 1 )  //if the light is incoerent 
 	{
      mComplexMatrix[0][0] = GenerateComplexNumber(-1* exp( ( 1*p.imag())),-1.0);

      mComplexMatrix[0][1] = 0.0;
      mComplexMatrix[1][0] = 0.0;
      mComplexMatrix[1][1] = GenerateComplexNumber(-1* exp((1*p.imag())), 1.0);  
   
	}
      
      else
	
	{  
      mComplexMatrix[0][0] = exp(-Ie*p); // z 
      
      mComplexMatrix[0][1] = 0.0;
      mComplexMatrix[1][0] = 0.0;
      mComplexMatrix[1][1] = exp(Ie*p); //      conj(z); 
         
	}
    
    }


complex <double> YehMatrix::PickElement (int i,int j)
{ 
   return mComplexMatrix[i][j];
}

   






















